$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#telatour",
        popover: {
          title: "Informações",
          description:
            "Aqui estão os dados de ramos de atuação a serem preenchidos.",
          position: "right",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Clique aqui para voltar para a tela de consulta.",
          position: "right",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar os dados preenchidos.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let codServico = parametros[parametros.length - 1];

  await preencheCampos(codServico);

  async function preencheCampos(codigo) {

    $('#txtCodigo').val(codigo);

    const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
      `JSON={ "tabela":"TABSERV",
                "camposSelect":["CODIGO, DESCRICAO"],
                "where": ["CODIGO = '${codigo}'"]}`, null);

    if (!response) {
      return;
    }

    let jsonStr = (await response.json()).RESULT[0];
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    if (jsonStr.length == 0) {
      return;
    }

    $('#txtDescricao').val(jsonStr[0].DESCRICAO);
  };

  $('#btnVoltar').on('click', function () {
    msgAlerta('Deseja realmente voltar? Os dados preenchidos serão perdidos.', async () => {
      await deletaRegistro("CADTABSERVICO", getCookie("usuario"), codServico);
      window.location.href = `${BASE_URI}/cadtabservico`;
    })
  });

  $('#btnGravar').on('click', async function () {

    if ($('#txtCodigo').val() == '') {
      msgErro('Código não pode ser em branco, impossível continuar');
      return;
    }

    if ($('#txtDescricao').val() == '') {
      msgErro('Descrição não pode ser em branco, impossível continuar');
      return;
    }

    msgAlerta('Deseja realmente gravar os dados?', async () => {
      await gravaDados();
    });

  });

  $('input').keyup(function () {
    $(this).val($(this).val().toUpperCase());
  });

  async function gravaDados() {

    try {
      $.LoadingOverlay('show');
      try {

        servico = {
          CODIGO: $('#txtCodigo').val(),
          DESCRICAO: $('#txtDescricao').val()
        };

        let response = await requisicao("POST", `/Sisplan/Cadastros/V1/cadtabservico?`, `JSON=${JSON.stringify(servico)}`);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        }

        toastr
          .success("Cadastro efetuado com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/cadtabservico`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });

      } catch (error) {
        console.error(error);
        msgAlerta('Não foi possível gravar os dados!');
      }

    } finally {
      $.LoadingOverlay("hide");
      await deletaRegistro("CADTABSERVICO", getCookie("usuario"), codServico);
    }

  };

});
