$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de um embarque.',
          position: 'right'
        }
      },
      {
        element: '#tabelaEmbarque',
        popover: {
          title: 'Tabela Embarque',
          description: 'Aqui estão os dados dos embarques cadastrados.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("EMBARQUE");

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  if (colunas == null || colunas == undefined || colunas.acesso_embarque == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acesso_embarque: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  };

  addFuncoesBotoes();
  await consultaEmbarque();

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaEmbarque').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.acesso_embarque ?? ['EMPRESA']);
  })

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaEmbarque();
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "embarque/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaEmbarque').on('click', '#btn-alterar-embarque', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaEmbarque').DataTable().row($(this).parents("tr")).data();
      mensagemAlterarFechada(this, data[1]);
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaEmbarque').on('click', '#btn-excluir-embarque', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      if (validaAberto(this)) {
        msgAguardaConfirmacao("Realmente deseja excluir o embarque?", () => { excluiEmbarque(this) }, () => { })
      } else {
        msgAlerta("Este embarque está finalizado, impossível continuar!")
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiEmbarque(embarque) {
    const data = $("#tabelaEmbarque").DataTable().row($(embarque).parents("tr")).data();
    await excluiRegistro(data[1]);
  };

  $("#tabelaEmbarque").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaEmbarque").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("EMBARQUE", data[1]);
      if (registroLiberado) {
        mensagemAlterarFechada(this, data[1]);
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar");
    }
  });

  function mensagemAlterarFechada(dataTable, data) {
    if (validaAberto(dataTable)) {
      window.location.href = `embarque/${data}`;
    } else {
      msgAguardaConfirmacao("Embarque já está finalizado. \nDeseja visualizar?", () => { window.location.href = `embarque/${data}`; }, () => { })
    };
  }

  $('#tabelaEmbarque').on('click', '#btn-finalizar-embarque', async function () {
    if (!validaAberto(this)) {
      msgAlerta("Este embarque já está finalizado. Impossível Continuar!");
      return;
    };

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      msgAguardaConfirmacao("Realmente deseja finalizar o embarque?", () => { abrirFecharEmbarque("FECHAR", this) }, () => { })
    } else {
      msgAlertaSemConfirmacao("Sem permissão para completar a operação!");
    };
  });

  $('#tabelaEmbarque').on('click', '#btn-reabrir-embarque', async function () {
    if (validaAberto(this)) {
      msgAlerta("Este embarque já está aberto. Impossível Continuar!");
      return;
    };

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      await senhaSupervisor(
        "Necessário senha de Supervisor para Reabrir o Embarque.",
        () => { abrirFecharEmbarque("REABRIR", this) },
        '',
        false,
        undefined,
        undefined,
        undefined,
        false,
        "EMBARQUE"
      );
    } else {
      msgAlertaSemConfirmacao("Sem permissão para completar a operação!");
    };
  });

  async function abrirFecharEmbarque(tipo, embarque) {
    let data = $('#tabelaEmbarque').DataTable().row($(embarque).parents('tr')).data();
    if (tipo === "REABRIR") {
      await reabreEmbarque(data);
    } else {
      await finalizaEmbarque(data);
    };
  };

  function validaAberto(embarque) {
    let data = $('#tabelaEmbarque').DataTable().row($(embarque).parents('tr')).data();
    if (data[3] === '1') {
      return false;
    };
    return true;
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '   <div class="dropdown"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      `      ${data}` +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button id="btn-alterar-embarque" class="dropdown-item" href="">Alterar</button>' +
      '    <button id="btn-excluir-embarque" class="dropdown-item" href="">Excluir</button>' +
      '    <button id="btn-finalizar-embarque" class="dropdown-item" href="">Finalizar</button>' +
      '    <button id="btn-reabrir-embarque" class="dropdown-item" href="">Reabrir</button>';
    retorno += '</div>' +
      '  </div>' +
      '</div>';
    return retorno;
  };

  function validaSituacao(data) {
    return data === '1' ? 'FECHADO' : 'PENDENTE';
  }

  async function validaTransportadora(data) {
    if (data === "")
      return data;

    const response = await requisicao(
      'GET', '/Sisplan/Funcoes/v1/pesquisa?',
      `JSON={ "tabela":"tabtran", 
      "camposSelect":["nome"], 
      "where": ["codigo = '${data}'"]}`
      , null
    );

    if (!response || !response.ok)
      return data;

    const nomeTrans = await response.json();

    const nome = nomeTrans.RESULT?.[0]?.[0]?.NOME || "NAO_EXISTE"
    return nome;
  };

  function transportadoraNome(data, meta) {
    const id = `transp-${meta.row}`;
    const codigo = data;

    validaTransportadora(codigo).then(nome => {
      const elemento = document.getElementById(id);
      if (elemento) {
        elemento.innerText = nome !== "NAO_EXISTE" ? nome : `${codigo} (não existe cadastrada)`;
        $(`#${id}`).addClass(nome !== "NAO_EXISTE" ? "EXISTE" : "NAO_EXISTE");
      };
    });

    return `<span style="white-space: nowrap; width: 100%; height: 100%;" id="${id}"></span>`;
  };

  async function consultaEmbarque() {
    try {
      $.LoadingOverlay("show");
      let where = '';

      if ($("#txtDataCadDe").val() != "01-01-1200" || $("#txtDataCadAte").val() != "01-12-2500") {
        where += `AND NOTA_EMBARQUE.DT_CADASTRO >= '${$("#txtDataCadDe").val()}' AND NOTA_EMBARQUE.DT_CADASTRO <= '${$("#txtDataCadAte").val()}'`;
      }
      where += pegaChave('#txtNumero') != '' ? ` AND NOTA_EMBARQUE.NUMERO = '${pegaChave('#txtNumero')}'` : '';
      where += pegaChave('#txtNota') != '' ? ` AND NOTA_EMBARQUE.FATURA = '${pegaChave('#txtNota')}'` : '';
      where += pegaChave('#txtCliente') != '' ? ` AND NOTA.CODCLI = '${pegaChave('#txtCliente')}'` : '';
      where += pegaChave('#txtTransporte') != '' ? ` AND NOTA_EMBARQUE.TRANSPORT = '${pegaChave('#txtTransporte')}'` : '';
      if ($("#radioPendentes").is(':checked')) {
        where += `AND NOTA_EMBARQUE.SITUACAO = '0'`
      }
      if ($('#radioFaturados').is(':checked')) {
        where += `AND NOTA_EMBARQUE.SITUACAO = '1'`
      }

      $("#tabelaEmbarque").DataTable({
        destroy: true,
        lengthChange: true,
        scrollY: "50vh",
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "POST",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{ "tabela":"NOTA_EMBARQUE", "camposSelect":["NOTA_EMBARQUE.FATURA", "NOTA_EMBARQUE.NUMERO", "NOTA_EMBARQUE.SERIE", "NOTA_EMBARQUE.SITUACAO",` +
              `"NOTA_EMBARQUE.TRANSPORT", "NOTA_EMBARQUE.DT_CADASTRO", "NOTA_EMBARQUE.DT_FINALIZADO"],` +
              `"leftjoin": [` +
              `{"tabela" : "TABTRAN", "condicao" : "TABTRAN.CODIGO = NOTA_EMBARQUE.TRANSPORT"},` +
              `{"tabela" : "NOTA", "condicao" : "NOTA_EMBARQUE.FATURA = NOTA.FATURA"}],` +
              `"groupby": ["NOTA_EMBARQUE.NUMERO",` +
              `"NOTA_EMBARQUE.FATURA",` +
              `"NOTA_EMBARQUE.SERIE",` +
              `"NOTA_EMBARQUE.TRANSPORT",` +
              `"NOTA_EMBARQUE.SITUACAO",` +
              `"NOTA_EMBARQUE.DT_CADASTRO",` +
              `"NOTA_EMBARQUE.DT_FINALIZADO"], ` +
              `"orderby": ["NOTA_EMBARQUE.DT_CADASTRO DESC"],` +
              `"where": ["1=1 ${where}"]}`,
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
          {
            targets: [3], render: function (data, type, row) {
              return validaSituacao(data);
            }
          },
          {
            targets: [4],
            render: function (data, type, row, meta) {
              return transportadoraNome(data, meta)
            }
          }
        ],
      });
    } catch (error) {
      console.error(error.message);
      $.LoadingOverlay("hide");
    } finally {
      if ($.fn.DataTable.isDataTable('#tabelaEmbarque')) {
        $("#tabelaEmbarque").DataTable().columns.adjust().draw(false);
      }
    }

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    $('#tabelaEmbarque_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEmbarque_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcel').prop('title', 'Exportar')

    $('#buttonExcel').on('click', async function () {
      const tabela = $("#tabelaEmbarque").DataTable().data().toArray();

      const dados = tabela.map((item) => ({
        'FATURA': item[0].toString(),
        'NUMERO': item[1].toString(),
        'SERIE': item[2].toString(),
        'SITUACAO': item[3].toString().replace('0', '0 - PENDENTE').replace('1', '1 - FATURADO'),
        'TRANSPORTE': item[4].toString(),
        'DATA CAD': item[5].toString(),
        'DATA FIM': item[6].toString(),
      }))

      if (dados.length > 0) {
        await exportaCSV("", "", undefined, null, 'Relatório controle de embarque', '', '', 999, false, false, dados);
      } else {
        msgAlerta("Não foi possível exportar, sem dados na tabela.")
      };
    })

    $('#buttonColVis').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#tabelaEmbarque').DataTable().columns().every(function () {
      if ((colunasInvisiveis.acesso_embarque).indexOf(this.dataSrc()) != -1) {
        this.visible(false);
      }
    });

    $.LoadingOverlay("hide");
  };

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = {}
        valorLinha.NUMERO = data
        const response = await requisicao('DELETE', '/sisplan/embarque/v1/excluirembarque?', `JSON=${JSON.stringify(valorLinha)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload() });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function finalizaEmbarque(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = {}
        valorLinha.NUMERO = data[1];
        const transportadoraExiste = await validaTransportadora(data[4]) !== "NAO_EXISTE"

        if (transportadoraExiste) {
          funcFinalizaEmbarque(valorLinha)          
        } else {
          msgAguardaConfirmacao(
            `A transportadora deste embarque (${data[4]}) não existe. \nDeseja mesmo continuar?`,
            async ()=>{ await funcFinalizaEmbarque(valorLinha) },
            ()=>{}
          )
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function funcFinalizaEmbarque(valorLinha) {
    const response = await requisicao('POST', '/sisplan/embarque/v1/finalizarembarque?', `JSON=${JSON.stringify(valorLinha)}`, null);
    if (!response) {
      return;
    }
    if (response.status != 200) {
      msgAlerta('Não foi possivel finalizar o embarque, verifique!')
      return;
    }
    criaMensagemSucesso('Embarque finalizado!', () => { window.location.reload() });
  };

  async function reabreEmbarque(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = {}
        valorLinha.NUMERO = data[1]
        const response = await requisicao('POST', '/sisplan/embarque/v1/reabreembarque?', `JSON=${JSON.stringify(valorLinha)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          msgAlerta('Não foi possivel reabrir o embarque, verifique!')
          return;
        }
        criaMensagemSucesso('Embarque reaberto!', () => { window.location.reload() });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  function addFuncoesBotoes() {

    $("#btn-Nota").pesquisa_serverside(
      ['#txtNota'],
      ["NOTA.FATURA"],
      ["TABTRAN.CODIGO"],
      `{
        "tabela":"NOTA", 
        "camposSelect":["NOTA.FATURA", "TABTRAN.CODIGO"],
        "leftjoin": [{"tabela": "TABTRAN", "condicao": "NOTA.TRANSPORT = TABTRAN.CODIGO"}
        ]
      }`,
      'Pesquisa Nota'
    );

    $("#txtNota").autocompleta(2,
      `JSON={ 
        "tabela":"NOTA",
        "camposSelect":"[NOTA.FATURA CHAVE, TABTRAN.CODIGO DESCRICAO]", 
        "leftjoin":[
          {"tabela":"TABTRAN", "condicao":"NOTA.TRANSPORT = TABTRAN.CODIGO"}
        ]
      }`);

    $('#btn-limpa-Nota').on('click', function () { $('#txtNota').val(''); });

    $("#btn-Numero").pesquisa_serverside(
      ['#txtNumero'],
      ["NOTA_EMBARQUE.NUMERO"],
      ["NOTA_EMBARQUE.FATURA"],
      `{
        "tabela":"NOTA_EMBARQUE", 
        "camposSelect":["NOTA_EMBARQUE.NUMERO", "NOTA_EMBARQUE.FATURA"]
      }`,
      'Pesquisa Número'
    );

    $("#txtNumero").autocompleta(
      1, `JSON={ "tabela":"NOTA_EMBARQUE", "camposSelect":[ "NUMERO chave", "FATURA descricao"], "where": null}`
    )

    $('#btn-limpa-Numero').on('click', function () { $('#txtNumero').val(''); });

    $("#txtCliente").autocompleta(2, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"]}`);
    $("#btn-Cliente").pesquisa_serverside(["#txtCliente"], ["CODCLI"], ["NOME"], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ]}`, "Pesquisa Cliente");
    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').val(''); });

    $("#txtTransporte").autocompleta(2, `JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"]}`);
    $("#btn-Transporte").pesquisa_serverside(["#txtTransporte"], ["CODIGO"], ["NOME"], `{"tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ]}`, "Pesquisa Trasnportadora");
    $('#btn-limpa-Transporte').on('click', function () { $('#txtTransporte').val(''); });

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtNota').val('');
      $('#txtCliente').val('');
      $('#txtNumero').val('');
      $('#txtTransporte').val('');
      $('#radioTodos').prop('checked', true);
      $('#txtGrupoProdConsulta').val('');
      $('#txtTipoProdConsulta').val('');
      $("#txtDataCadDe").val("1200-01-01");
      $("#txtDataCadAte").val("2500-12-31");
      $("#txtDataFinalizacaoAte").val("2500-12-31");
    });
  };

  $('#btnConfirmarColunas').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      let novasColunas = retornaNovasColunasInvisiveis();

      if (novasColunas.includes('0')) {
        msgAlerta('A coluna "FATURA" não pode ser ocultada.');
        novasColunas = novasColunas.filter(index => index !== '0');
      }

      localStorage.setItem(
        'colunasInvisiveisRelatorios',
        JSON.stringify({ ...colunas, acesso_embarque: novasColunas })
      );

      const tabela = $('#tabelaEmbarque').DataTable();

      tabela.columns().visible(true);

      tabela.columns().every(function () {
        const colIndex = this.index();
        if (novasColunas.includes(String(colIndex))) {
          this.visible(false);
        }
      });

    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });
});