$(document).ready(async function () {

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.relBaixaConsumos == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relBaixaConsumos: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relBaixaConsumos: novasColunas }))

            $('#tabelaRelBaixaConsumos').DataTable().columns().visible(true);
            $('#tabelaRelBaixaConsumos').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })

    $('#tutorial').on('click', function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: 'Sair',
                closeBtnText: 'Fechar',
                nextBtnText: 'Próximo',
                prevBtnText: 'Anterior',
                allowClose: false
            });
            driver.defineSteps([{
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnImprimir',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para imprimir um relatório.',
                    position: 'right'
                }
            },
            {
                element: '#buttonColVis',
                popover: {
                    title: 'Configurar colunas visíveis ',
                    description: 'Clique aqui para selecionar as colunas que deseja retirar da tabela.',
                    position: 'right'
                }
            },
            {
                element: '#buttonExcel',
                popover: {
                    title: 'Botão Exportar',
                    description: 'Clique aqui para exportar a tabela em CSV.',
                    position: 'right'
                }
            },
            ]);
            driver.start();
        });
    });

    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show');
    });

    await preencheOrdenacaoTela('RelBaixaConsumos');

    //AutoCompleta
    $('#txtGrupos').pesquisa_variosServerside(1, '{ "tabela":"GRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#txtSubGrupos').pesquisa_variosServerside(1, '{ "tabela":"SUBGRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#txtCliBlocoK').pesquisa_variosServerside(1, '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'CODCLI', 'NOME');
    $('#txtDeposito').pesquisa_variosServerside(1, '{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#txtMaterial').pesquisa_variosServerside(1, '{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#txtCorMaterial').pesquisa_variosServerside(1, '{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}', 'COR', 'DESCRICAO');
    $('#txtLinha').pesquisa_variosServerside(1, '{ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#txtColecao').pesquisa_variosServerside(1, '{ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#txtTipoOF').autocompleta(1, `JSON={ "tabela":"TIPO", "camposSelect":[ "ID", "DESCRICAO" ], "where": null}`);
    $('#txtSetor').pesquisa_variosServerside(1, '{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#txtLote').pesquisa_variosServerside(1, `{ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO" ], "where": ["LOTE <> ''"]}`, 'LOTE', 'CODIGO');
    $('#txtOFs').pesquisa_variosServerside(1, `{ "tabela":"OF1", "camposSelect":["NUMERO", "CODIGO" ], "where": null}`, 'NUMERO', 'CODIGO');

    //btn-consultar
    $('#btn-GruposConsulta').pesquisa_serversideSel('#txtGrupos', `{ "tabela":"GRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Grupos');
    $('#btn-SubGruposConsulta').pesquisa_serversideSel('#txtSubGrupos', `{ "tabela":"SUBGRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Sub. Grupos');
    $('#btn-CliBlocoKConsulta').pesquisa_serversideSel('#txtCliBlocoK', `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}`, 'Pesquisa de Cliente');
    $('#btn-DepositoConsulta').pesquisa_serversideSel('#txtDeposito', `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Depósito');
    $('#btn-MaterialConsulta').pesquisa_serversideSel('#txtMaterial', `{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Material');
    $('#btn-CorMaterialConsulta').pesquisa_serversideSel('#txtCorMaterial', `{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}`, 'Pesquisa de Cor');
    $('#btn-LinhaConsulta').pesquisa_serversideSel('#txtLinha', `{ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Linha');
    $('#btn-ColecaoConsulta').pesquisa_serversideSel('#txtColecao', `{ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Coleção');
    $('#btn-TipoOFConsulta').pesquisa_serverside(['#txtTipoOF'], ['ID'], ['DESCRICAO'], '{"tabela":"TIPO", "camposSelect":[ "ID", "DESCRICAO"], "where": null}', 'Pesquisa de Tipo');
    $('#btn-SetorConsulta').pesquisa_serversideSel('#txtSetor', `{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Setor');
    $('#btn-LoteConsulta').pesquisa_serversideSel('#txtLote', `{ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO" ], "where": ["LOTE <> ''"]}`, 'Pesquisa de Lote');
    $('#btn-OFsConsulta').pesquisa_serversideSel('#txtOFs', `{ "tabela":"OF1", "camposSelect":["NUMERO", "CODIGO" ], "where": null}`, 'Pesquisa de OF');

    //limpa pesquisa
    $('#btn-limpa-Grupos').on('click', function () { $('#txtGrupos').empty().trigger('change') })
    $('#btn-limpa-SubGrupos').on('click', function () { $('#txtSubGrupos').empty().trigger('change') })
    $('#btn-limpa-CliBlocoK').on('click', function () { $('#txtCliBlocoK').empty().trigger('change') })
    $('#btn-limpa-Deposito').on('click', function () { $('#txtDeposito').empty().trigger('change') })
    $('#btn-limpa-Material').on('click', function () { $('#txtMaterial').empty().trigger('change') })
    $('#btn-limpa-CorMaterial').on('click', function () { $('#txtCorMaterial').empty().trigger('change') })
    $('#btn-limpa-Linha').on('click', function () { $('#txtLinha').empty().trigger('change') })
    $('#btn-limpa-Colecao').on('click', function () { $('#txtColecao').empty().trigger('change') })
    $('#btn-limpa-TipoOF').on('click', function () { $('#txtTipoOF').empty().trigger('change') })
    $('#btn-limpa-Setor').on('click', function () { $('#txtSetor').empty().trigger('change') })
    $('#btn-limpa-Lote').on('click', function () { $('#txtLote').empty().trigger('change') })
    $('#btn-limpa-OFs').on('click', function () { $('#txtOFs').empty().trigger('change') })

    //limpas todos os campos
    $('#btnLimparFiltros').on('click', async function () {
        $('#dtBaixaDe').val('1200-01-01');
        $('#dtBaixaAte').val('2500-12-31');
        $('#txtGrupos').empty().trigger('change')
        $('#txtSubGrupos').empty().trigger('change')
        $('#txtCliBlocoK').empty().trigger('change')
        $('#txtDeposito').empty().trigger('change')
        $('#txtMaterial').empty().trigger('change')
        $('#txtCorMaterial').empty().trigger('change')
        $('#txtLinha').empty().trigger('change')
        $('#txtColecao').empty().trigger('change')
        $('#txtTipoOF').empty().trigger('change')
        $('#txtSetor').empty().trigger('change')
        $('#txtLote').empty().trigger('change')
        $('#txtOFs').empty().trigger('change')
        $('#radioOFTodas').prop('checked', true);
        $('#radioTodas').prop('checked', true);
    });

    async function retornaFiltros() {
        const dtBaixaDe = $('#dtBaixaDe').val();
        const dtBaixaAte = $('#dtBaixaAte').val();

        let situacaoOF = '0'
        if ($('#radioOFPendentes').is(':checked')) {
            situacaoOF = '1'
        } else if ($('#radioOFFinalizados').is(':checked')) {
            situacaoOF = '2'
        }
        let situacao = '0'
        if ($('#radioPendentes').is(':checked')) {
            situacao = '1'
        } else if ($('#radioBaixados').is(':checked')) {
            situacao = '2'
        }

        const grupos = await formataListas($('#txtGrupos').val().toString());
        const subGrupos = await formataListas($('#txtSubGrupos').val().toString());
        const cliBlocoK = await formataListas($('#txtCliBlocoK').val().toString());
        const depositos = await formataListas($('#txtDeposito').val().toString());
        const materiais = await formataListas($('#txtMaterial').val().toString());
        const corMateriais = await formataListas($('#txtCorMaterial').val().toString());
        const linhas = await formataListas($('#txtLinha').val().toString());
        const colecoes = await formataListas($('#txtColecao').val().toString());
        const tipoOF = pegaChave('#txtTipoOF')
        const setores = await formataListas($('#txtSetor').val().toString());
        const lotes = await formataListas($('#txtLote').val().toString());
        const ofs = await formataListas($('#txtOFs').val().toString());

        const retorno =
            `DTBAIXADE=${dtBaixaDe}&` +
            `DTBAIXAATE=${dtBaixaAte}&` +
            `SITUACAOOF=${situacaoOF}&` +
            `SITUACAO=${situacao}&` +
            `GRUPOS=${grupos}&` +
            `SUBGRUPOS=${subGrupos}&` +
            `CLIBLOCOK=${cliBlocoK}&` +
            `DEPOSITOS=${depositos}&` +
            `MATERIAIS=${materiais}&` +
            `CORMATERIAIS=${corMateriais}&` +
            `LINHAS=${linhas}&` +
            `COLECOES=${colecoes}&` +
            `TIPOOF=${tipoOF}&` +
            `SETORES=${setores}&` +
            `LOTES=${lotes}&` +
            `OFS=${ofs}`;

        return retorno;
    }

    retornaHintRelatorio('btnImprimir', 'RelBaixaConsumos')

    $('#txtOrdem').on('change', function () {
        retornaHintRelatorio('btnImprimir', $("#txtOrdem option")
            .toArray()
            .map(map => {
                return [map.selected, $(map)
                    .attr('nome_prt')]
            })
            .filter(filter => filter[0] == true)[0][1])
    })

    async function fazConsulta() {
        if ($.fn.DataTable.isDataTable('#tabelaRelBaixaConsumos')) {
            $("#tabelaRelBaixaConsumos").DataTable().destroy();
            $("#tabelaRelBaixaConsumos").empty();
        }
        try {
            dataSetCols = [];
            $.LoadingOverlay('show');
            try {
                const url = "/sisplan/impressao/v1/consultarelbaixaconsumos?";
                const filtros = await retornaFiltros();
                const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 720000);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();

                if (jsonStr.length == 0) {
                    msgAlerta("Nenhum registro encontrado!");
                    if ($.fn.DataTable.isDataTable('#tabelaRelBaixaConsumos')) {
                        $('#tabelaRelBaixaConsumos').DataTable().destroy();
                        $('#tabelaRelBaixaConsumos').empty();
                    }
                    return;
                }

                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem);
                    return;
                };

                // let keys = Object.keys(jsonStr[0]);

                // keys.forEach((k) => {
                //     dataSetCols.push({
                //         title: k,
                //         data: k,
                //     });
                // });

                const columns = [
                    {
                        data: 'NUMERO',
                        title: 'Número',
                    },
                    {
                        data: 'CODIGO',
                        title: 'Código',
                    },
                    {
                        data: 'DESCRICAO',
                        title: 'Descrição',
                    },
                    {
                        data: 'COD_PRODUTO',
                        title: 'Cód. Produto',
                    },
                    {
                        data: 'DESC_PRODUTO',
                        title: 'Desc. Produto',
                    },
                    {
                        data: 'COR',
                        title: 'Cor',
                    },
                    {
                        data: 'DESC_COR',
                        title: 'Desc. Cor',
                    },
                    {
                        data: 'QTDE',
                        title: 'Quantidade',
                    },
                    {
                        data: 'GRUPO',
                        title: 'Grupo',
                    },
                    {
                        data: 'DESC_GRUPO',
                        title: 'Desc. Grupo',
                    },
                    {
                        data: 'SUBGRUPO',
                        title: 'Subgrupo',
                    },
                    {
                        data: 'DESC_SUBGRUPO',
                        title: 'Desc. Subgrupo',
                    },
                    {
                        data: 'BLOCO_K',
                        title: 'Bloco K',
                    },
                    {
                        data: 'SETOR',
                        title: 'Setor',
                    },
                    {
                        data: 'DESC_SETOR',
                        title: 'Desc. Setor',
                    },
                    {
                        data: 'CODCRE_BLOCO_K',
                        title: 'Codcre Bloco K',
                    },
                    {
                        data: 'NOME_CODCRE',
                        title: 'Nome Codcre',
                    },
                    {
                        data: 'UNIDADE',
                        title: 'Unidade',
                    },
                    {
                        data: 'CONS_ORIG',
                        title: 'Consumos Orig.',
                    },
                    {
                        data: 'BAIXADO',
                        title: 'Baixado',
                    },
                    {
                        data: 'SALDO',
                        title: 'Saldo',
                    },
                    {
                        data: 'CONS_REAL',
                        title: 'Consumos Real',
                    },
                    {
                        data: 'APLICACAO',
                        title: 'Aplicação',
                    },
                    {
                        data: 'DESC_APLICACAO',
                        title: 'Desc. Aplicação',
                    },
                    {
                        data: 'FINALIZADO',
                        title: 'Finalizado',
                    },
                ];

                const colunasDireita = [];

                columns.forEach((item, index) => {
                    if (['QTDE', 'CONS_ORIG', 'BAIXADO', 'SALDO', 'CONS_REAL'].includes(item.data)) {
                        colunasDireita.push(index);
                    }
                });

                $('#tabelaRelBaixaConsumos').DataTable({
                    bPaginate: true,
                    destroy: true,
                    colReorder: true,
                    autoWidth: true,
                    columns,
                    scrollX: true,
                    data: jsonStr,
                    columnDefs: [
                        {
                            targets: colunasDireita,
                            className: "text-right pr-2"
                        }
                    ]
                });

                const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

                $('#tabelaRelBaixaConsumos_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
                $('#tabelaRelBaixaConsumos_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');
                $('#tabelaRelBaixaConsumos_length').addClass('mb-2');

                $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
                $('#buttonExcel').prop('title', 'Exportar')

                $('#buttonColVis').on('click', async function () {
                    $.LoadingOverlay('show');
                    $('#modal-ColunasVisiveis').modal('show');
                    $.LoadingOverlay('hide');
                });

                $('#buttonExcel').on('click', async function () {
                    const url = '/sisplan/impressao/v1/consultarelbaixaconsumos?';
                    const filtros = await retornaFiltros();
                    await exportaCSV(url, filtros, false, null, 'Relatório de Baixa de Consumos', '#tabelaRelBaixaConsumos');
                })

                $('#tabelaRelBaixaConsumos').DataTable().columns().every(
                    function () {
                        if ((colunasInvisiveis.relBaixaConsumos).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    }
                )

                const dados = $('#tabelaRelBaixaConsumos').DataTable().data().toArray();

                Graficos.criarGrafico({
                    container: 'graficoRelBaixaConsumos',
                    tipo: 'column',
                    dados: dados,
                    nomeSerie: 'Quantidade',
                    colunasAgrupamento: ['CONS_ORIG', 'BAIXADO', 'SALDO', 'CONS_REAL'],
                    colunasValor: ['CONS_ORIG', 'BAIXADO', 'SALDO', 'CONS_REAL']
                });
            } catch (error) {
                console.error(error);
                msgErro("Não foi possível fazer consulta do relatório! Tente novamente.");
                return;
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/impressao/v1/imprimirrelbaixaconsumo?`;
                const filtros = await retornaFiltros();
                const ordem = `&TELA_ORDENACAO=RelBaixaConsumo&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelBaixaConsumo');
                const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelBaixaConsumo');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnConsultar').on('click', async function () {
        await fazConsulta();
        $('#modal-filtros').modal('hide');
    });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaRelBaixaConsumos').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.relatorioCliente ?? [])
    })
});